% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program LuminanceHomogeneity.m
% Press ESC to exit.
function LuminanceHomogeneity

%% Display Setup Module

% Define display parameters
whichScreen = max(Screen('screens'));
p.ScreenGamma = 2; % from monitor calibration
p.ScreenBackground = 1;

% Open display window and hide the mouse cursor
if exist('onCleanup', 'class'), oC_Obj = onCleanup(@()sca), end 
        % close pre-exiting PTB Screen window
PsychImaging('PrepareConfiguration'); 
PsychImaging('AddTask', 'General', ...
     'FloatingPoint32BitIfPossible'); 
        % set up a 32-bit framebuffer
PsychImaging('AddTask', 'General', ...
     'NormalizedHighresColorRange');
PsychImaging('AddTask', 'FinalFormatting', ...
     'DisplayColorCorrection', 'SimpleGamma');
[windowPtr p.ScreenRect] = PsychImaging('OpenWindow', ...
      whichScreen, p.ScreenBackground);
PsychColorCorrection('SetEncodingGamma', windowPtr, ...
      1 / p.ScreenGamma);
HideCursor;
Screen('Flip', windowPtr);

WaitTill('esc'); % wait till ESC is pressed

%% System Reinstatement Module
Screen('CloseAll'); % close window and textures


